import { useQuery } from "@tanstack/react-query";
import { Skeleton } from "@/components/ui/skeleton";
import { Badge } from "@/components/ui/badge";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import WebsiteLayout from "@/components/WebsiteLayout";
import { 
  BookOpen, 
  Settings, 
  Zap, 
  FileText, 
  BarChart3,
  Users,
  Target,
  Lightbulb,
  Building,
  Globe,
  Rocket,
  ArrowRight,
  CheckCircle,
  TrendingUp,
  Award,
  Brain,
  Clock,
  Shield
} from "lucide-react";

export default function Solutions() {
  const { data: pageData, isLoading } = useQuery({
    queryKey: ['backend/api/cms/pages/solutions'],
  });

  if (isLoading) {
    return (
      <WebsiteLayout>
        <div className="bg-gradient-to-r from-[#1A1A40] to-[#ED1C24] text-white">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="py-16">
              <Skeleton className="h-12 w-96 mb-4 bg-white/20" />
              <Skeleton className="h-6 w-[600px] bg-white/20" />
            </div>
          </div>
        </div>
      </WebsiteLayout>
    );
  }

  return (
    <WebsiteLayout>
      {/* Hero Section */}
      <div className="bg-gradient-to-r from-[#1A1A40] to-[#ED1C24] text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="py-16">
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              Solutions for Learning and Development
            </h1>
            <p className="text-xl md:text-2xl text-white/90 max-w-3xl">
              Customized learning solutions designed to meet your organization's unique needs and drive measurable business results
            </p>
          </div>
        </div>
      </div>

      {/* Solutions Overview */}
      <div className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">
              Comprehensive Learning Solutions
            </h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              From corporate training programs to individual professional development, we deliver results that matter
            </p>
          </div>

          <div className="grid lg:grid-cols-3 gap-8">
            {[
              {
                title: "Corporate Learning Solutions",
                description: "Tailored programs for organizational development and employee growth",
                icon: Building,
                features: ["Leadership Development", "Skills Assessment", "Performance Tracking", "Custom Content"]
              },
              {
                title: "Individual Professional Development",
                description: "Personal growth programs for career advancement and skill enhancement",
                icon: Users,
                features: ["Career Planning", "Skill Certification", "Mentorship Programs", "Flexible Learning"]
              },
              {
                title: "Educational Institution Partnerships",
                description: "Collaborative solutions for universities and educational providers",
                icon: Globe,
                features: ["Curriculum Development", "Faculty Training", "Student Assessment", "Accreditation Support"]
              }
            ].map((solution, index) => (
              <Card key={index} className="border-2 border-gray-100 hover:border-[#ED1C24] transition-colors">
                <CardHeader>
                  <solution.icon className="h-12 w-12 text-[#ED1C24] mb-4" />
                  <CardTitle className="text-[#1A1A40]">{solution.title}</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 mb-6">{solution.description}</p>
                  <div className="space-y-2">
                    {solution.features.map((feature, idx) => (
                      <div key={idx} className="flex items-center text-sm">
                        <CheckCircle className="h-4 w-4 text-green-500 mr-2" />
                        <span className="text-gray-700">{feature}</span>
                      </div>
                    ))}
                  </div>
                  <Button className="w-full mt-6 bg-[#ED1C24] hover:bg-red-700 text-white">
                    Learn More
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </div>

      {/* Call to Action */}
      <div className="py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="bg-gradient-to-r from-[#1A1A40] to-[#ED1C24] rounded-lg p-12 text-white text-center">
            <h3 className="text-3xl font-bold mb-4">Ready to Transform Your Learning Strategy?</h3>
            <p className="text-xl mb-8 max-w-2xl mx-auto">
              Let our experts help you design and implement a learning solution that drives real business results
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button className="bg-white text-[#1A1A40] hover:bg-gray-100">
                <Users className="mr-2 h-4 w-4" />
                Request Consultation
              </Button>
              <Button variant="outline" className="border-white text-white bg-transparent hover:bg-white hover:text-[#1A1A40]">
                <FileText className="mr-2 h-4 w-4" />
                Download Solutions Guide
              </Button>
            </div>
          </div>
        </div>
      </div>
    </WebsiteLayout>
  );
}