import Header from "@/components/Header";

export default function BePartOfOurStory() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Be Part of Our Story
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Be Part of Our Story - Join the IBDL community and network
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 gap-8">
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
            <h3 className="text-2xl font-semibold text-[#1A1A40] dark:text-white mb-4">Partner With Us</h3>
            <p className="text-gray-600 dark:text-gray-300 mb-6">
              Explore partnership opportunities and collaboration with IBDL to expand your reach and impact.
            </p>
            <div className="w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center">
              <span className="text-lg font-bold text-white">P</span>
            </div>
          </div>
          
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
            <h3 className="text-2xl font-semibold text-[#1A1A40] dark:text-white mb-4">Join Our Global Community</h3>
            <p className="text-gray-600 dark:text-gray-300 mb-6">
              Connect with professionals worldwide and become part of our growing global learning community.
            </p>
            <div className="w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center">
              <span className="text-lg font-bold text-white">C</span>
            </div>
          </div>
        </div>
      </div>
    </div>
    </>
  );
}