import Header from "@/components/Header";

export default function AccreditationServices() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Accreditation Services
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Accreditation Services - Professional certification and accreditation programs
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {[
            'Training Provider',
            'Exam Provider', 
            'Corporate/Government',
            'Professional IBDL Trainer',
            'Professional Course'
          ].map((service, index) => (
            <div key={index} className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
              <h3 className="text-lg font-semibold text-[#1A1A40] dark:text-white mb-4">
                {service}
              </h3>
              <p className="text-gray-600 dark:text-gray-300">
                Professional accreditation for {service.toLowerCase()}
              </p>
            </div>
          ))}
        </div>
      </div>
    </div>
    </>
  );
}