import Header from "@/components/Header";
import Footer from "@/components/Footer";

export default function ProgramBrochures() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Program Brochures & Media Kit
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Program Brochures & Media Kit - Download resources and materials
          </p>
        </div>
        
        <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
          <div className="text-center">
            <div className="w-20 h-20 bg-[#ED1C24] rounded-full flex items-center justify-center mx-auto mb-6">
              <span className="text-2xl font-bold text-white">IBDL</span>
            </div>
            <h2 className="text-2xl font-semibold text-[#1A1A40] dark:text-white mb-4">
              Program Brochures & Media Kit Coming Soon
            </h2>
            <p className="text-gray-600 dark:text-gray-300 mb-6">
              This page will provide downloadable program brochures, media kits, and promotional materials.
            </p>
          </div>
        </div>
      </div>
    </div>
    <Footer />
    </>
  );
}