import Header from "@/components/Header";
import Footer from "@/components/Footer";

export default function EventsConferences() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Events & Conferences
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Connect, Learn, and Network at IBDL's Global Events
          </p>
        </div>
        
        <div className="space-y-12">
          {/* Upcoming Events Section */}
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
            <h2 className="text-3xl font-bold text-[#1A1A40] dark:text-white mb-6">
              Upcoming Events
            </h2>
            <p className="text-gray-700 dark:text-gray-300 text-lg leading-relaxed mb-8">
              Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer 
              took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but 
              also the leap into electronic typesetting, remaining essentially unchanged.
            </p>
            
            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              {/* Event Card 1 */}
              <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-6">
                <div className="w-full h-48 bg-gray-200 dark:bg-gray-600 rounded-lg mb-4 flex items-center justify-center">
                  <span className="text-gray-500 dark:text-gray-400">An image placeholder will be placed here.</span>
                </div>
                <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-2">Global Leadership Summit 2024</h3>
                <p className="text-gray-600 dark:text-gray-300 mb-4">Join industry leaders for a comprehensive exploration of modern leadership strategies.</p>
                <div className="text-sm text-gray-500 dark:text-gray-400">
                  <p>Date: March 15-17, 2024</p>
                  <p>Location: Dubai, UAE</p>
                </div>
              </div>

              {/* Event Card 2 */}
              <div className="border border-gray-200 dark:border-gray-600 rounded-lg p-6">
                <div className="w-full h-48 bg-gray-200 dark:bg-gray-600 rounded-lg mb-4 flex items-center justify-center">
                  <span className="text-gray-500 dark:text-gray-400">An image placeholder will be placed here.</span>
                </div>
                <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-2">Digital Transformation Conference</h3>
                <p className="text-gray-600 dark:text-gray-300 mb-4">Explore the latest trends in digital transformation and innovation.</p>
                <div className="text-sm text-gray-500 dark:text-gray-400">
                  <p>Date: April 22-24, 2024</p>
                  <p>Location: London, UK</p>
                </div>
              </div>
            </div>
          </div>

          {/* Past Events Section */}
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
            <h2 className="text-3xl font-bold text-[#1A1A40] dark:text-white mb-6">
              Past Events & Highlights
            </h2>
            <div className="space-y-6">
              <p className="text-gray-700 dark:text-gray-300 text-lg leading-relaxed">
                It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, 
                and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
              </p>
              
              <div className="bg-gray-50 dark:bg-slate-700 p-6 rounded-lg">
                <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Event Gallery</h3>
                <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
                  {[1, 2, 3, 4].map((i) => (
                    <div key={i} className="aspect-square bg-gray-200 dark:bg-gray-600 rounded-lg flex items-center justify-center">
                      <span className="text-xs text-gray-500 dark:text-gray-400 text-center">Image placeholder</span>
                    </div>
                  ))}
                </div>
              </div>
            </div>
          </div>

          {/* Call to Action */}
          <div className="bg-gradient-to-r from-[#ED1C24] to-[#1A1A40] rounded-lg shadow-lg p-8 text-white text-center">
            <h2 className="text-3xl font-bold mb-4">
              Stay Connected
            </h2>
            <p className="text-lg mb-6">
              Subscribe to our newsletter to receive updates about upcoming events, conferences, and exclusive learning opportunities.
            </p>
            <button className="bg-white text-[#1A1A40] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors">
              Subscribe Now
            </button>
          </div>
        </div>
      </div>
    </div>
    <Footer />
    </>
  );
}