import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { Award, Users, Clock, CheckCircle, Star, Globe, BookOpen, Target } from "lucide-react";

export default function Qualifications() {
  const qualifications = [
    {
      name: "IBDL Essential",
      level: "Level 1 - Foundation",
      duration: "40 hours",
      description: "Foundation-level business administration skills for emerging professionals",
      features: [
        "Business Administration Fundamentals",
        "Communication Skills",
        "Problem-Solving Techniques",
        "Team Collaboration",
        "Digital Literacy"
      ],
      targetAudience: "Recent graduates, entry-level professionals",
      certification: "IBDL Essential Certificate",
      color: "bg-blue-50 text-blue-700 border-blue-200"
    },
    {
      name: "IBDL Professional",
      level: "Level 2 - Professional",
      duration: "60 hours",
      description: "Management development for second-line leaders and supervisors",
      features: [
        "Leadership Development",
        "Strategic Planning",
        "Performance Management",
        "Financial Management",
        "Change Management"
      ],
      targetAudience: "Mid-level managers, team leaders",
      certification: "IBDL Professional Certificate",
      color: "bg-green-50 text-green-700 border-green-200"
    },
    {
      name: "IBDL Master",
      level: "Level 3 - Master",
      duration: "80 hours",
      description: "Advanced business strategy for senior leaders and executives",
      features: [
        "Executive Leadership",
        "Strategic Innovation",
        "Global Business Management",
        "Digital Transformation",
        "Organizational Excellence"
      ],
      targetAudience: "Senior executives, C-level professionals",
      certification: "IBDL Master Certificate",
      color: "bg-purple-50 text-purple-700 border-purple-200"
    },
    {
      name: "Certified Educator",
      level: "Specialized",
      duration: "50 hours",
      description: "Professional development for educators and trainers",
      features: [
        "Educational Leadership",
        "Curriculum Development",
        "Assessment Methods",
        "Technology Integration",
        "Learning Analytics"
      ],
      targetAudience: "Educators, trainers, academic leaders",
      certification: "IBDL Certified Educator",
      color: "bg-orange-50 text-orange-700 border-orange-200"
    },
    {
      name: "Certified Industrial Engineer",
      level: "Specialized",
      duration: "70 hours",
      description: "Engineering management and industrial optimization",
      features: [
        "Process Optimization",
        "Quality Management",
        "Supply Chain Management",
        "Lean Manufacturing",
        "Industrial Analytics"
      ],
      targetAudience: "Industrial engineers, manufacturing professionals",
      certification: "IBDL Certified Industrial Engineer",
      color: "bg-red-50 text-red-700 border-red-200"
    },
    {
      name: "CNPO Professional",
      level: "Specialized",
      duration: "60 hours",
      description: "Non-profit organization management and leadership",
      features: [
        "Non-Profit Leadership",
        "Fundraising Strategies",
        "Volunteer Management",
        "Impact Measurement",
        "Stakeholder Engagement"
      ],
      targetAudience: "Non-profit leaders, social entrepreneurs",
      certification: "CNPO Professional Certificate",
      color: "bg-teal-50 text-teal-700 border-teal-200"
    }
  ];

  const pathwaySteps = [
    {
      step: "01",
      title: "Choose Your Path",
      description: "Select the qualification that matches your career level and goals"
    },
    {
      step: "02",
      title: "Enroll & Study",
      description: "Access comprehensive learning materials and interactive content"
    },
    {
      step: "03",
      title: "Complete Assessment",
      description: "Demonstrate your knowledge through comprehensive evaluations"
    },
    {
      step: "04",
      title: "Earn Certificate",
      description: "Receive your globally recognized IBDL qualification"
    }
  ];

  const benefits = [
    {
      icon: Globe,
      title: "Global Recognition",
      description: "Accepted by employers and institutions worldwide"
    },
    {
      icon: Award,
      title: "Career Advancement",
      description: "Proven to accelerate career growth and opportunities"
    },
    {
      icon: Users,
      title: "Professional Network",
      description: "Join a community of certified professionals globally"
    },
    {
      icon: Target,
      title: "Skill Validation",
      description: "Demonstrate your expertise with industry-recognized credentials"
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Header */}
      <div className="bg-gradient-to-r from-[#1A1A40] to-[#2A2A50] text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
          <div className="text-center">
            <Badge variant="secondary" className="mb-4 bg-red-100 text-red-700">
              Professional Development
            </Badge>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              IBDL Qualifications
            </h1>
            <p className="text-xl text-gray-300 max-w-3xl mx-auto">
              Globally recognized professional qualifications designed to advance your career 
              and validate your expertise in international business
            </p>
            <div className="mt-8 flex justify-center space-x-4">
              <div className="text-center">
                <div className="text-3xl font-bold text-[#ED1C24]">222,000+</div>
                <div className="text-sm text-gray-300">Certified Professionals</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-[#ED1C24]">39</div>
                <div className="text-sm text-gray-300">Countries</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-[#ED1C24]">735</div>
                <div className="text-sm text-gray-300">Exam Providers</div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        {/* Qualifications Grid */}
        <div className="mb-16">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Professional Qualifications</h2>
            <p className="text-gray-600 text-lg max-w-2xl mx-auto">
              Choose from our comprehensive range of professional qualifications designed for every career stage
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {qualifications.map((qual, index) => (
              <Card key={index} className={`${qual.color} border-2 hover:shadow-lg transition-shadow`}>
                <CardHeader>
                  <div className="flex items-center justify-between mb-2">
                    <Badge variant="outline">{qual.level}</Badge>
                    <div className="flex items-center text-sm text-gray-500">
                      <Clock className="w-4 h-4 mr-1" />
                      {qual.duration}
                    </div>
                  </div>
                  <CardTitle className="text-xl font-bold text-[#1A1A40]">{qual.name}</CardTitle>
                  <p className="text-gray-600">{qual.description}</p>
                </CardHeader>
                <CardContent>
                  <div className="space-y-4">
                    <div>
                      <h4 className="font-semibold text-[#1A1A40] mb-2">Key Features:</h4>
                      <ul className="space-y-1">
                        {qual.features.map((feature, featureIndex) => (
                          <li key={featureIndex} className="flex items-center text-sm text-gray-600">
                            <CheckCircle className="w-4 h-4 mr-2 text-green-500" />
                            {feature}
                          </li>
                        ))}
                      </ul>
                    </div>
                    <div>
                      <h4 className="font-semibold text-[#1A1A40] mb-1">Target Audience:</h4>
                      <p className="text-sm text-gray-600">{qual.targetAudience}</p>
                    </div>
                    <div>
                      <h4 className="font-semibold text-[#1A1A40] mb-1">Certification:</h4>
                      <p className="text-sm text-gray-600">{qual.certification}</p>
                    </div>
                    <Button className="w-full bg-[#ED1C24] hover:bg-[#C41E1E] text-white">
                      Learn More
                    </Button>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* Certification Pathway */}
        <div className="mb-16">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Certification Pathway</h2>
            <p className="text-gray-600 text-lg max-w-2xl mx-auto">
              Your journey to professional excellence in four simple steps
            </p>
          </div>

          <div className="grid md:grid-cols-4 gap-8">
            {pathwaySteps.map((step, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-[#1A1A40] to-[#ED1C24] rounded-full flex items-center justify-center mx-auto mb-4">
                  <span className="text-white font-bold text-lg">{step.step}</span>
                </div>
                <h3 className="text-lg font-bold text-[#1A1A40] mb-2">{step.title}</h3>
                <p className="text-gray-600">{step.description}</p>
                {index < pathwaySteps.length - 1 && (
                  <div className="hidden md:block w-full h-0.5 bg-gray-300 mt-8 relative">
                    <div className="absolute right-0 top-0 w-0 h-0 border-l-4 border-l-gray-300 border-t-2 border-t-transparent border-b-2 border-b-transparent"></div>
                  </div>
                )}
              </div>
            ))}
          </div>
        </div>

        {/* Benefits */}
        <div className="mb-16">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Why Choose IBDL Qualifications?</h2>
            <p className="text-gray-600 text-lg max-w-2xl mx-auto">
              Unlock your potential with internationally recognized credentials
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {benefits.map((benefit, index) => (
              <Card key={index} className="text-center hover:shadow-lg transition-shadow">
                <CardHeader>
                  <div className="w-16 h-16 bg-gradient-to-br from-[#1A1A40] to-[#ED1C24] rounded-full flex items-center justify-center mx-auto mb-4">
                    <benefit.icon className="w-8 h-8 text-white" />
                  </div>
                  <CardTitle className="text-lg font-bold text-[#1A1A40]">{benefit.title}</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600">{benefit.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* CTA Section */}
        <Card className="bg-gradient-to-r from-[#1A1A40] to-[#2A2A50] text-white text-center">
          <CardContent className="py-16">
            <h2 className="text-3xl font-bold mb-4">Ready to Start Your Journey?</h2>
            <p className="text-xl text-gray-300 mb-8 max-w-2xl mx-auto">
              Join thousands of professionals who have advanced their careers with IBDL qualifications
            </p>
            <div className="flex justify-center space-x-4">
              <Button size="lg" className="bg-[#ED1C24] hover:bg-[#C41E1E] text-white">
                <BookOpen className="w-5 h-5 mr-2" />
                Browse Qualifications
              </Button>
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-[#1A1A40]">
                <Users className="w-5 h-5 mr-2" />
                Contact Advisor
              </Button>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}