import Header from "@/components/Header";

export default function VentureHub() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            IBDL Venture Hub
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to IBDL Venture Hub - Entrepreneurship and innovation programs
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 gap-8">
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Core Qualifications</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Certified Disciplined Entrepreneur</li>
              <li>• Certified Incubation Management (CIM)</li>
            </ul>
          </div>
          
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Specialized Executive Programs</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Angel Playbook Bootcamp</li>
              <li>• Capital Raise Bootcamp</li>
              <li>• Data-Room Preparation Bootcamp</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    </>
  );
}