import Header from "@/components/Header";

export default function Qualifications() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Qualifications
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Qualifications - Explore our comprehensive certification programs
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 gap-8">
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Core Qualifications</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• IBDL Essential</li>
              <li>• IBDL Professional</li>
              <li>• IBDL Master</li>
            </ul>
          </div>
          
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Specialized Qualifications</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Certified Educator</li>
              <li>• Certified Industrial Engineer</li>
              <li>• CNPO Practitioner</li>
              <li>• CNPO Management Professional</li>
              <li>• Foresight & Innovation Programs</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    </>
  );
}