import Header from "@/components/Header";

export default function LearningGames() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Learning Games
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Learning Games - Engage with our interactive educational games
          </p>
        </div>
        
        <div className="grid md:grid-cols-3 gap-8">
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Core Games</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Win vs. War</li>
              <li>• Master Board Game</li>
              <li>• Sparta</li>
            </ul>
          </div>
          
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Online Games</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Mogul CEO</li>
              <li>• Maven Marketing</li>
              <li>• Micromatic</li>
            </ul>
          </div>
          
          <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-6">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-4">Specialized Games</h3>
            <ul className="space-y-2 text-gray-600 dark:text-gray-300">
              <li>• Pitch Deck</li>
              <li>• Synergy Stack</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    </>
  );
}