import Header from "@/components/Header";

export default function AssessmentServices() {
  return (
    <>
      <Header />
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50 dark:from-slate-900 dark:to-slate-800">
      <div className="max-w-6xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-[#1A1A40] dark:text-white mb-4">
            Assessment Services
          </h1>
          <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
            Welcome to Assessment Services - Professional evaluation and testing solutions
          </p>
        </div>
        
        <div className="bg-white dark:bg-slate-800 rounded-lg shadow-lg p-8">
          <div className="text-center">
            <h3 className="text-xl font-semibold text-[#1A1A40] dark:text-white mb-6">Core Assessment</h3>
            <div className="grid md:grid-cols-2 gap-8">
              <div className="p-6 bg-gray-50 dark:bg-slate-700 rounded-lg">
                <h4 className="text-lg font-medium text-[#1A1A40] dark:text-white mb-2">PQP</h4>
                <p className="text-gray-600 dark:text-gray-300">Professional Qualification Program assessment</p>
              </div>
              <div className="p-6 bg-gray-50 dark:bg-slate-700 rounded-lg">
                <h4 className="text-lg font-medium text-[#1A1A40] dark:text-white mb-2">CPAT</h4>
                <p className="text-gray-600 dark:text-gray-300">Competency-based Performance Assessment Tool</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    </>
  );
}