import React, { useState, useEffect } from "react";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import SharedLayout from "@/components/SharedLayout";
import { GraduationCap, Book, BookOpen, Shield, Brain, Award, Users, Building, Settings, 
         CheckCircle, Clock, Star, ArrowRight, Play, Globe, Zap, BarChart3, ChevronDown, Menu, X, 
         ShoppingBag, Mail, Briefcase, Languages, Target, Lightbulb, TrendingUp, 
         BookmarkPlus, Rocket, MonitorSpeaker, UserPlus, Home, Linkedin, Twitter, Facebook, 
         Instagram, Youtube, MessageCircle, FileText, Handshake, Headphones, Newspaper, Calendar } from "lucide-react";
import ibdlLogo from "@assets/logo_1751230646761.png";
import footerLogo from "@assets/footer-logo_1751304691992.png";
import certificateImage from "@assets/Certificate-for home page-01_1751316063831.jpg";

// Partner logos imports
import partner1 from "@assets/11_1751317749215.png";
import partner2 from "@assets/12_1751317749217.png";
import partner3 from "@assets/13_1751317749217.png";
import partner4 from "@assets/14_1751317749218.png";
import partner5 from "@assets/15_1751317749219.png";
import partner6 from "@assets/16_1751317749220.png";
import partner7 from "@assets/17_1751317749221.png";
import partner8 from "@assets/18_1751317749222.png";
import partner9 from "@assets/19_1751317749223.png";
import partner10 from "@assets/20_1751317749224.png";
import partner11 from "@assets/21_1751317749225.jpg";
import partner12 from "@assets/22_1751317749226.png";
import ibdlIcon from "@assets/IBDL Icon_1751318336054.png";
import accreditationLogo from "@assets/Accreditation_1751316145777.png";
import educationLogo from "@assets/Education_1751316145778.png";
import qualificationsLogo from "@assets/Qualifications_1751316145780.png";
import servicesLogo from "@assets/Services_1751316145781.png";
import professionalServicesLogo from "@assets/Services1_1751316145784.png";
import simulationLogo from "@assets/Simulation_1751316145785.png";

interface LandingProps {
  onShowLogin?: () => void;
  onShowGetStarted?: () => void;
}

export default function Landing({ onShowLogin, onShowGetStarted }: LandingProps) {
  const [currentSlide, setCurrentSlide] = useState(0);

  const handleSignIn = () => {
    if (onShowLogin) {
      onShowLogin();
    } else {
      window.location.href = "/login";
    }
  };

  const handleGetStarted = () => {
    if (onShowGetStarted) {
      onShowGetStarted();
    }
  };

  const slides = [
    {
      badge: "Leading Organization",
      title: "Inspire to Learn: A Motto That Drives Success",
      subtitle: "IBDL Learning Group is a leading organisation in international business education. Founded in 2006, partnering with Missouri State University, Abertay University, University of Dundee, and Edinburgh Napier University.",
      primaryButton: "Start Learning",
      secondaryButton: "Enterprise Solutions",
      theme: "light",
      features: ["Blockchain Verified Certificates", "Multi-Tenant Architecture"]
    },
    {
      badge: "🚀 Leading International Business Education Since 2006",
      title: (
        <>
          We develop the{" "}
          <span className="text-[#ED1C24]">learning journeys</span>{" "}
          that enable every person and organization to{" "}
          <span className="text-[#ED1C24]">move forward</span>
        </>
      ),
      subtitle: "Empowering professionals and organizations worldwide through innovative qualifications, business simulations, psychometric assessments, and executive education programs.",
      primaryButton: "Start Learning Journey",
      secondaryButton: "Explore Programs",
      theme: "dark"
    }
  ];

  // Auto-advance slides
  useEffect(() => {
    const timer = setInterval(() => {
      setCurrentSlide((prev) => (prev + 1) % slides.length);
    }, 6000);
    return () => clearInterval(timer);
  }, [slides.length]);

  const features = [
    {
      logo: qualificationsLogo,
      title: "Professional Qualifications",
      description: "IBDL Essential, Professional, and Master certifications aligned with our Body of Knowledge framework",
      color: "bg-blue-100 text-blue-600"
    },
    {
      logo: simulationLogo,
      title: "Business Simulations", 
      description: "Win vs. War, Master Board Game, Sparta, Maven, and Mogul CEO for immersive learning experiences",
      color: "bg-emerald-100 text-emerald-600"
    },
    {
      logo: servicesLogo,
      title: "Assessment Services",
      description: "PQP psychometric and CPAT cognitive assessments for comprehensive professional evaluation", 
      color: "bg-purple-100 text-purple-600"
    },
    {
      logo: educationLogo,
      title: "Executive Education",
      description: "Leadership, Women Leadership, Economic Diplomacy, and Digital Diplomacy programs",
      color: "bg-orange-100 text-orange-600"
    },
    {
      logo: professionalServicesLogo,
      title: "Professional Services",
      description: "Corporate training programs, university partnerships, and customized learning solutions tailored to your needs",
      color: "bg-red-100 text-red-600"
    },
    {
      logo: accreditationLogo,
      title: "Accreditation Services",
      description: "Quality assurance, program accreditation, and certification services across 39 countries worldwide",
      color: "bg-indigo-100 text-indigo-600"
    }
  ];

  const stats = [
    { number: "222,000+", label: "Exams Delivered", icon: Award },
    { number: "735", label: "Exam Providers", icon: Building },
    { number: "39", label: "Countries", icon: Globe },
    { number: "120+", label: "Strategic Partners", icon: Users }
  ];

  return (
    <SharedLayout>
      {/* Hero Slideshow Section */}
      <section className="relative overflow-hidden">
        <div className="relative max-w-full">
          <div className="relative">
            {/* Slides */}
            <div className="relative h-[500px] flex items-center justify-center">
              {slides.map((slide, index) => (
                <div
                  key={index}
                  className={`absolute inset-0 transition-all duration-1000 ${
                    index === currentSlide
                      ? 'opacity-100 transform translate-x-0'
                      : index < currentSlide
                      ? 'opacity-0 transform -translate-x-full'
                      : 'opacity-0 transform translate-x-full'
                  } ${
                    slide.theme === 'light' 
                      ? 'bg-gradient-to-br from-gray-50 to-white' 
                      : 'bg-gradient-to-br from-[#1A1A40] via-[#2A2A60] to-[#ED1C24]'
                  }`}
                >
                  {slide.theme === 'dark' && <div className="absolute inset-0 bg-black/20"></div>}
                  
                  <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-center h-full">
                    {/* Content for slides */}
                    {slide.theme === 'light' ? (
                      <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center w-full">
                        {/* Left Content */}
                        <div className="text-left">
                          <Badge className="mb-6 bg-[#1A1A40]/10 text-[#1A1A40] border-[#1A1A40]/20 hover:bg-[#1A1A40]/20">
                            {slide.badge}
                          </Badge>
                          <h1 className="text-4xl lg:text-5xl font-bold mb-6 text-[#1A1A40] leading-tight">
                            {slide.title}
                          </h1>
                          <p className="text-lg mb-8 text-gray-600 leading-relaxed">
                            {slide.subtitle}
                          </p>
                          <div className="flex flex-col sm:flex-row gap-4">
                            <Button 
                              size="lg" 
                              className="bg-[#ED1C24] hover:bg-red-700 text-white px-8 py-3"
                              onClick={handleSignIn}
                            >
                              <Play className="mr-2 h-4 w-4" />
                              {slide.primaryButton}
                            </Button>
                            <Button 
                              size="lg" 
                              variant="outline" 
                              className="border-[#1A1A40] text-[#1A1A40] hover:bg-[#1A1A40] hover:text-white px-8 py-3"
                            >
                              <Building className="mr-2 h-4 w-4" />
                              {slide.secondaryButton}
                            </Button>
                          </div>
                          {/* Features */}
                          {slide.features && (
                            <div className="flex flex-col sm:flex-row gap-6 mt-8">
                              {slide.features.map((feature, idx) => (
                                <div key={idx} className="flex items-center text-gray-600">
                                  <div className="w-2 h-2 bg-[#ED1C24] rounded-full mr-3"></div>
                                  <span className="text-sm">{feature}</span>
                                </div>
                              ))}
                            </div>
                          )}
                        </div>
                        
                        {/* Right Graphic - Analytics Dashboard Mockup */}
                        <div className="hidden lg:block">
                          <div className="relative">
                            {/* Main Dashboard Card */}
                            <div className="bg-white rounded-xl shadow-lg border border-gray-200 p-6 transform rotate-2">
                              {/* Header with colored dots */}
                              <div className="flex items-center justify-between mb-6">
                                <div className="flex space-x-2">
                                  <div className="w-3 h-3 bg-[#ED1C24] rounded-full"></div>
                                  <div className="w-3 h-3 bg-gray-300 rounded-full"></div>
                                  <div className="w-3 h-3 bg-green-500 rounded-full"></div>
                                </div>
                              </div>
                              
                              {/* Content Bars */}
                              <div className="space-y-4 mb-6">
                                <div className="h-2 bg-gray-200 rounded-full"></div>
                                <div className="h-2 bg-gray-200 rounded-full w-3/4"></div>
                                <div className="h-2 bg-gray-200 rounded-full w-1/2"></div>
                              </div>
                              
                              {/* Chart Bars */}
                              <div className="flex items-end space-x-3 h-20">
                                <div className="w-4 bg-[#ED1C24] h-12 rounded-t"></div>
                                <div className="w-4 bg-purple-400 h-16 rounded-t"></div>
                                <div className="w-4 bg-green-400 h-20 rounded-t"></div>
                                <div className="w-4 bg-blue-400 h-8 rounded-t"></div>
                                <div className="w-4 bg-yellow-400 h-14 rounded-t"></div>
                              </div>
                            </div>
                            
                            {/* Floating elements */}
                            <div className="absolute -top-4 -left-4 w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-full opacity-60"></div>
                            <div className="absolute -bottom-2 -right-2 w-12 h-12 bg-gradient-to-br from-green-100 to-green-200 rounded-full opacity-60"></div>
                          </div>
                        </div>
                      </div>
                    ) : (
                      /* Original centered layout for dark theme */
                      <div className="text-center">
                        <Badge className="mb-6 bg-white/10 text-white border-white/20 hover:bg-white/20">
                          {slide.badge}
                        </Badge>
                        <h1 className="text-4xl md:text-6xl font-bold mb-6 text-white">
                          {slide.title}
                        </h1>
                        <p className="text-xl md:text-2xl mb-8 max-w-4xl mx-auto text-gray-200">
                          {slide.subtitle}
                        </p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center">
                          <Button 
                            size="lg" 
                            className="bg-[#ED1C24] hover:bg-red-700 text-white px-8 py-4 text-lg"
                            onClick={handleSignIn}
                          >
                            <Play className="mr-2 h-5 w-5" />
                            {slide.primaryButton}
                          </Button>
                          <Button 
                            size="lg" 
                            variant="outline" 
                            className="border-white text-[#1A1A40] bg-white hover:bg-white hover:text-[#1A1A40] px-8 py-4 text-lg"
                          >
                            <Book className="mr-2 h-5 w-5" />
                            {slide.secondaryButton}
                          </Button>
                        </div>
                      </div>
                    )}
                  </div>
                </div>
              ))}
            </div>

            {/* Slide Indicators */}
            <div className="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-2 z-10">
              {slides.map((slide, index) => (
                <button
                  key={index}
                  onClick={() => setCurrentSlide(index)}
                  className={`w-3 h-3 rounded-full transition-all duration-300 ${
                    index === currentSlide 
                      ? 'bg-[#ED1C24] scale-125' 
                      : 'bg-gray-400 hover:bg-gray-500'
                  }`}
                />
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            {stats.map((stat, index) => (
              <div key={index} className="flex flex-col items-center">
                <div className="bg-[#1A1A40] rounded-full w-16 h-16 flex items-center justify-center mb-4">
                  <stat.icon className="h-8 w-8 text-white" />
                </div>
                <div className="text-3xl font-bold text-[#1A1A40] mb-2">{stat.number}</div>
                <div className="text-gray-600">{stat.label}</div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-[#1A1A40] mb-4">
              Comprehensive Learning Solutions
            </h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              Empowering individuals and organizations through innovative education, assessment, and professional development programs.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow duration-300 border-0 bg-white">
                <CardContent className="p-8">
                  <div className="flex items-center justify-center w-24 h-24 bg-white rounded-lg shadow-sm mb-6 mx-auto border">
                    <img src={feature.logo} alt={feature.title} className="w-16 h-16 object-contain" />
                  </div>
                  <h3 className="text-xl font-semibold text-[#1A1A40] mb-4 text-center">
                    {feature.title}
                  </h3>
                  <p className="text-gray-600 text-center leading-relaxed">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Rest of the component content can be added here... */}
    </SharedLayout>
  );
}