import React, { useState, useEffect } from "react";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { GraduationCap, Book, BookOpen, Shield, Brain, Award, Users, Building, Settings, 
         CheckCircle, Clock, Star, ArrowRight, Play, Globe, Zap, BarChart3, ChevronDown, Menu, X, 
         ShoppingBag, Mail, Briefcase, Languages, Target, Lightbulb, TrendingUp, 
         BookmarkPlus, Rocket, MonitorSpeaker, UserPlus, Home, Linkedin, Twitter, Facebook, 
         Instagram, Youtube, MessageCircle, FileText, Handshake, Headphones, Newspaper, Calendar } from "lucide-react";
import Header from "@/components/Header";
import ibdlLogo from "@assets/logo_1751230646761.png";
import footerLogo from "@assets/footer-logo_1751304691992.png";
import certificateImage from "@assets/Certificate-for home page-01_1751316063831.jpg";

// Partner logos imports
import partner1 from "@assets/11_1751317749215.png";
import partner2 from "@assets/12_1751317749217.png";
import partner3 from "@assets/13_1751317749217.png";
import partner4 from "@assets/14_1751317749218.png";
import partner5 from "@assets/15_1751317749219.png";
import partner6 from "@assets/16_1751317749220.png";
import partner7 from "@assets/17_1751317749221.png";
import partner8 from "@assets/18_1751317749222.png";
import partner9 from "@assets/19_1751317749223.png";
import partner10 from "@assets/20_1751317749224.png";
import partner11 from "@assets/21_1751317749225.jpg";
import partner12 from "@assets/22_1751317749226.png";
import ibdlIcon from "@assets/IBDL Icon_1751318336054.png";
import accreditationLogo from "@assets/Accreditation_1751316145777.png";
import educationLogo from "@assets/Education_1751316145778.png";
import qualificationsLogo from "@assets/Qualifications_1751316145780.png";
import servicesLogo from "@assets/Services_1751316145781.png";
import professionalServicesLogo from "@assets/Services1_1751316145784.png";
import simulationLogo from "@assets/Simulation_1751316145785.png";

interface LandingProps {
  onShowLogin?: () => void;
  onShowGetStarted?: () => void;
}

export default function Landing({ onShowLogin, onShowGetStarted }: LandingProps) {
  const [currentSlide, setCurrentSlide] = useState(0);

  const handleSignIn = () => {
    if (onShowLogin) {
      onShowLogin();
    } else {
      window.location.href = "/login";
    }
  };

  const handleGetStarted = () => {
    if (onShowGetStarted) {
      onShowGetStarted();
    }
  };



  const slides = [
    {
      badge: "Leading Organization",
      title: "Inspire to Learn: A Motto That Drives Success",
      subtitle: "IBDL Learning Group is a leading organisation in international business education. Founded in 2006, partnering with Missouri State University, Abertay University, University of Dundee, and Edinburgh Napier University.",
      primaryButton: "Start Learning",
      secondaryButton: "Enterprise Solutions",
      theme: "light",
      features: ["Blockchain Verified Certificates", "Multi-Tenant Architecture"]
    },
    {
      badge: "🚀 Leading International Business Education Since 2006",
      title: (
        <>
          We develop the{" "}
          <span className="text-[#ED1C24]">learning journeys</span>{" "}
          that enable every person and organization to{" "}
          <span className="text-[#ED1C24]">move forward</span>
        </>
      ),
      subtitle: "Empowering professionals and organizations worldwide through innovative qualifications, business simulations, psychometric assessments, and executive education programs.",
      primaryButton: "Start Learning Journey",
      secondaryButton: "Explore Programs",
      theme: "dark"
    }
  ];

  // Auto-advance slides
  useEffect(() => {
    const timer = setInterval(() => {
      setCurrentSlide((prev) => (prev + 1) % slides.length);
    }, 6000);
    return () => clearInterval(timer);
  }, [slides.length]);

  const features = [
    {
      logo: qualificationsLogo,
      title: "Professional Qualifications",
      description: "IBDL Essential, Professional, and Master certifications aligned with our Body of Knowledge framework",
      color: "bg-blue-100 text-blue-600"
    },
    {
      logo: simulationLogo,
      title: "Business Simulations", 
      description: "Win vs. War, Master Board Game, Sparta, Maven, and Mogul CEO for immersive learning experiences",
      color: "bg-emerald-100 text-emerald-600"
    },
    {
      logo: servicesLogo,
      title: "Assessment Services",
      description: "PQP psychometric and CPAT cognitive assessments for comprehensive professional evaluation", 
      color: "bg-purple-100 text-purple-600"
    },
    {
      logo: educationLogo,
      title: "Executive Education",
      description: "Leadership, Women Leadership, Economic Diplomacy, and Digital Diplomacy programs",
      color: "bg-orange-100 text-orange-600"
    },
    {
      logo: professionalServicesLogo,
      title: "Professional Services",
      description: "Corporate training programs, university partnerships, and customized learning solutions tailored to your needs",
      color: "bg-red-100 text-red-600"
    },
    {
      logo: accreditationLogo,
      title: "Accreditation Services",
      description: "Quality assurance, program accreditation, and certification services across 39 countries worldwide",
      color: "bg-indigo-100 text-indigo-600"
    }
  ];

  const stats = [
    { number: "222,000+", label: "Exams Delivered", icon: Award },
    { number: "735", label: "Exam Providers", icon: Building },
    { number: "39", label: "Countries", icon: Globe },
    { number: "120+", label: "Strategic Partners", icon: Users }
  ];

  return (
    <div className="min-h-screen bg-white">
      {/* Enhanced Header Component with Hierarchical Navigation */}
      <Header />

      {/* Hero Slideshow Section */}
      <section className="relative overflow-hidden">
        <div className="relative max-w-full">
          <div className="relative">
            {/* Slides */}
            <div className="relative h-[500px] flex items-center justify-center">
              {slides.map((slide, index) => (
                <div
                  key={index}
                  className={`absolute inset-0 transition-all duration-1000 ${
                    index === currentSlide
                      ? 'opacity-100 transform translate-x-0'
                      : index < currentSlide
                      ? 'opacity-0 transform -translate-x-full'
                      : 'opacity-0 transform translate-x-full'
                  } ${
                    slide.theme === 'light' 
                      ? 'bg-gradient-to-br from-gray-50 to-white' 
                      : 'bg-gradient-to-br from-[#1A1A40] via-[#2A2A60] to-[#ED1C24]'
                  }`}
                >
                  {slide.theme === 'dark' && <div className="absolute inset-0 bg-black/20"></div>}
                  
                  <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-center h-full">
                    {/* Special layout for light-themed slide */}
                    {slide.theme === 'light' ? (
                      <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center w-full">
                        {/* Left Content */}
                        <div className="text-left">
                          <Badge className="text-[#1A1A40] border-[#1A1A40]/20 hover:bg-[#1A1A40]/20 bg-[#1a1a4000] mt-[20px] mb-[20px] pl-[16px] pr-[16px] pt-[5px] pb-[5px]">
                            {slide.badge}
                          </Badge>
                          <h1 className="text-4xl lg:text-5xl font-bold mb-6 text-[#1A1A40] leading-tight">
                            {slide.title}
                          </h1>
                          <p className="text-lg mb-8 text-gray-600 leading-relaxed">
                            {slide.subtitle}
                          </p>
                          <div className="flex flex-col sm:flex-row gap-4 mb-8">
                            <Button 
                              size="lg" 
                              className="bg-[#ED1C24] hover:bg-red-700 text-white px-8 py-3"
                              onClick={handleSignIn}
                            >
                              <Play className="mr-2 h-4 w-4" />
                              {slide.primaryButton}
                            </Button>
                            <Button 
                              size="lg" 
                              variant="outline" 
                              className="border-[#1A1A40] text-[#1A1A40] hover:bg-[#1A1A40] hover:text-white px-8 py-3"
                            >
                              <Building className="mr-2 h-4 w-4" />
                              {slide.secondaryButton}
                            </Button>
                          </div>
                          {/* Features */}
                          {slide.features && (
                            <div className="flex flex-col sm:flex-row gap-6">
                              {slide.features.map((feature, idx) => (
                                <div key={idx} className="flex items-center text-gray-600">
                                  <div className="w-2 h-2 bg-[#ED1C24] rounded-full mr-3"></div>
                                  <span className="text-sm">{feature}</span>
                                </div>
                              ))}
                            </div>
                          )}
                        </div>
                        
                        {/* Right Graphic - Analytics Dashboard Mockup */}
                        <div className="hidden lg:block">
                          <div className="relative">
                            {/* Main Dashboard Card */}
                            <div className="bg-white rounded-xl shadow-lg border border-gray-200 p-6 transform rotate-2">
                              {/* Header with colored dots */}
                              <div className="flex items-center justify-between mb-6">
                                <div className="flex space-x-2">
                                  <div className="w-3 h-3 bg-[#ED1C24] rounded-full"></div>
                                  <div className="w-3 h-3 bg-gray-300 rounded-full"></div>
                                  <div className="w-3 h-3 bg-green-500 rounded-full"></div>
                                </div>
                              </div>
                              
                              {/* Content Bars */}
                              <div className="space-y-4 mb-6">
                                <div className="h-2 bg-gray-200 rounded-full"></div>
                                <div className="h-2 bg-gray-200 rounded-full w-3/4"></div>
                                <div className="h-2 bg-gray-200 rounded-full w-1/2"></div>
                              </div>
                              
                              {/* Chart Bars */}
                              <div className="flex items-end space-x-3 h-20">
                                <div className="w-4 bg-[#ED1C24] h-12 rounded-t"></div>
                                <div className="w-4 bg-purple-400 h-16 rounded-t"></div>
                                <div className="w-4 bg-green-400 h-20 rounded-t"></div>
                                <div className="w-4 bg-blue-400 h-8 rounded-t"></div>
                                <div className="w-4 bg-yellow-400 h-14 rounded-t"></div>
                              </div>
                            </div>
                            
                            {/* Floating elements */}
                            <div className="absolute -top-4 -left-4 w-16 h-16 bg-gradient-to-br from-blue-100 to-blue-200 rounded-full opacity-60"></div>
                            <div className="absolute -bottom-2 -right-2 w-12 h-12 bg-gradient-to-br from-green-100 to-green-200 rounded-full opacity-60"></div>
                          </div>
                        </div>
                      </div>
                    ) : (
                      /* Original centered layout for dark theme */
                      <div className="text-center">
                        <Badge className="mb-6 text-white border-white/20 hover:bg-white/20 bg-[#ffffff00]">
                          Leading International Business Education Since 2006
                        </Badge>
                        <h1 className="text-4xl md:text-6xl font-bold mb-6 text-white">
                          {slide.title}
                        </h1>
                        <p className="text-xl md:text-2xl mb-8 max-w-4xl mx-auto text-gray-200">
                          {slide.subtitle}
                        </p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center">
                          <Button 
                            size="lg" 
                            className="bg-[#ED1C24] hover:bg-red-700 text-white px-8 py-4 text-lg"
                            onClick={handleSignIn}
                          >
                            <Play className="mr-2 h-5 w-5" />
                            {slide.primaryButton}
                          </Button>
                          <Button 
                            size="lg" 
                            variant="outline" 
                            className="border-white text-[#1A1A40] bg-white hover:bg-white hover:text-[#1A1A40] px-8 py-4 text-lg"
                          >
                            <Book className="mr-2 h-5 w-5" />
                            {slide.secondaryButton}
                          </Button>
                        </div>
                      </div>
                    )}
                  </div>
                </div>
              ))}
            </div>

            {/* Slide Indicators */}
            <div className="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-2 z-10">
              {slides.map((slide, index) => (
                <button
                  key={index}
                  onClick={() => setCurrentSlide(index)}
                  className={`w-3 h-3 rounded-full transition-colors ${
                    index === currentSlide 
                      ? (slide.theme === 'light' ? 'bg-[#1A1A40]' : 'bg-white')
                      : (slide.theme === 'light' ? 'bg-[#1A1A40]/40' : 'bg-white/40')
                  }`}
                />
              ))}
            </div>

            {/* Navigation Arrows */}
            <button
              onClick={() => setCurrentSlide((prev) => (prev - 1 + slides.length) % slides.length)}
              className={`absolute left-4 top-1/2 transform -translate-y-1/2 transition-colors z-10 ${
                slides[currentSlide]?.theme === 'light'
                  ? 'text-[#1A1A40]/60 hover:text-[#1A1A40]'
                  : 'text-white/60 hover:text-white'
              }`}
            >
              <ChevronDown className="h-8 w-8 rotate-90" />
            </button>
            <button
              onClick={() => setCurrentSlide((prev) => (prev + 1) % slides.length)}
              className={`absolute right-4 top-1/2 transform -translate-y-1/2 transition-colors z-10 ${
                slides[currentSlide]?.theme === 'light'
                  ? 'text-[#1A1A40]/60 hover:text-[#1A1A40]'
                  : 'text-white/60 hover:text-white'
              }`}
            >
              <ChevronDown className="h-8 w-8 -rotate-90" />
            </button>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Our Global Impact</h2>
            <p className="text-xl text-gray-600">Transforming learning experiences across the globe</p>
          </div>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {stats.map((stat, index) => {
              const IconComponent = stat.icon;
              return (
                <div key={index} className="text-center">
                  <div className="flex justify-center mb-4">
                    <div className="w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center">
                      <IconComponent className="h-8 w-8 text-white" />
                    </div>
                  </div>
                  <div className="text-3xl font-bold text-[#1A1A40] mb-2">{stat.number}</div>
                  <div className="text-gray-600">{stat.label}</div>
                </div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Transcript & Regional Providers Section */}
      <section className="py-20 bg-gradient-to-br from-[#1A1A40] via-[#1A1A40] to-[#2A2A60]">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-white mb-4">Quick Access Services</h2>
            <p className="text-xl text-white/80 max-w-2xl mx-auto">
              Access your academic records and find authorized training providers in your region
            </p>
          </div>
          
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            {/* Transcript Section */}
            <div className="bg-white rounded-2xl p-8 shadow-xl border border-gray-100 hover:shadow-2xl transition-shadow">
              <div className="flex items-center mb-6">
                <div className="w-12 h-12 bg-gradient-to-br from-[#ED1C24] to-red-600 rounded-lg flex items-center justify-center mr-4">
                  <FileText className="h-6 w-6 text-white" />
                </div>
                <div>
                  <h3 className="text-2xl font-bold text-[#1A1A40] mb-1">TRANSCRIPT</h3>
                  <p className="text-gray-600">View your performance & certification records</p>
                </div>
              </div>
              
              <div className="space-y-4">
                <div className="relative">
                  <input 
                    type="text" 
                    placeholder="Enter your logbook number"
                    className="w-full px-4 py-4 border-2 border-gray-200 rounded-lg focus:border-[#ED1C24] focus:ring-2 focus:ring-[#ED1C24]/20 focus:outline-none transition-colors text-gray-700 placeholder-gray-400"
                  />
                </div>
                <Button className="w-full bg-gradient-to-r from-[#ED1C24] to-red-600 hover:from-red-700 hover:to-red-700 text-white py-4 text-lg font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all transform hover:scale-[1.02]">
                  <FileText className="mr-2 h-5 w-5" />
                  SEARCH TRANSCRIPT
                </Button>
              </div>
              
              <div className="mt-6 p-4 bg-gray-50 rounded-lg">
                <p className="text-sm text-gray-600">
                  <strong>Need help?</strong> Your logbook number can be found on your IBDL certificate or registration confirmation.
                </p>
              </div>
            </div>
            
            {/* Regional Providers Section */}
            <div className="bg-white rounded-2xl p-8 shadow-xl border border-gray-100 hover:shadow-2xl transition-shadow">
              <div className="flex items-center mb-6">
                <div className="w-12 h-12 bg-gradient-to-br from-[#1A1A40] to-[#2A2A60] rounded-lg flex items-center justify-center mr-4">
                  <Globe className="h-6 w-6 text-white" />
                </div>
                <div>
                  <h3 className="text-2xl font-bold text-[#1A1A40] mb-1">REGIONAL PROVIDERS</h3>
                  <p className="text-gray-600">Find your nearest authorized training center</p>
                </div>
              </div>
              
              <div className="space-y-4">
                <div className="relative">
                  <select className="w-full px-4 py-4 border-2 border-gray-200 rounded-lg focus:border-[#1A1A40] focus:ring-2 focus:ring-[#1A1A40]/20 focus:outline-none transition-colors text-gray-700 bg-white">
                    <option value="">Select your country or region</option>
                    <optgroup label="Middle East & North Africa">
                      <option value="algeria">Algeria</option>
                      <option value="egypt">Egypt</option>
                      <option value="jordan">Jordan</option>
                      <option value="lebanon">Lebanon</option>
                      <option value="morocco">Morocco</option>
                      <option value="oman">Oman</option>
                      <option value="qatar">Qatar</option>
                      <option value="saudi">Saudi Arabia</option>
                      <option value="tunisia">Tunisia</option>
                      <option value="uae">United Arab Emirates</option>
                    </optgroup>
                    <optgroup label="Europe & Americas">
                      <option value="uk">United Kingdom</option>
                      <option value="usa">United States</option>
                    </optgroup>
                  </select>
                </div>
                <Button className="w-full bg-gradient-to-r from-[#1A1A40] to-[#2A2A60] hover:from-[#2A2A60] hover:to-[#1A1A40] text-white py-4 text-lg font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all transform hover:scale-[1.02]">
                  <Globe className="mr-2 h-5 w-5" />
                  FIND PROVIDERS
                </Button>
              </div>
              
              <div className="mt-6 p-4 bg-gray-50 rounded-lg">
                <p className="text-sm text-gray-600">
                  <strong>Can't find your region?</strong> Contact our global support team for assistance with training options.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Comprehensive Learning Solutions</h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              From professional qualifications to executive education, we provide the tools and expertise 
              to accelerate your career and organizational growth.
            </p>
          </div>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => {
              return (
                <Card key={index} className="border-0 shadow-lg hover:shadow-xl transition-shadow group">
                  <CardContent className="p-8">
                    <div className="flex justify-center mb-6 group-hover:scale-110 transition-transform">
                      <img 
                        src={feature.logo} 
                        alt={`${feature.title} - IBDL Service Logo`}
                        className="h-20 w-auto max-w-full object-contain"
                      />
                    </div>
                    <h3 className="text-xl font-semibold text-[#1A1A40] mb-4">{feature.title}</h3>
                    <p className="text-gray-600 mb-6">{feature.description}</p>
                    <Button variant="ghost" className="text-[#ED1C24] hover:bg-red-50 p-0">
                      Learn More <ArrowRight className="ml-2 h-4 w-4" />
                    </Button>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* Strategic Goals Section */}
      <section className="py-20 bg-gradient-to-r from-[#1A1A40] to-[#2A2A60] text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold mb-4">Our Strategic Vision</h2>
            <p className="text-xl text-gray-300 max-w-3xl mx-auto">
              Four strategic pillars driving our mission to transform global business education
            </p>
          </div>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {[
              {
                icon: Zap,
                title: "Catalyse Exponential Value",
                description: "Accelerating organizational growth through innovative learning solutions"
              },
              {
                icon: Brain,
                title: "Pioneer Learning-Driven Model",
                description: "Leading the transformation of how organizations approach professional development"
              },
              {
                icon: Globe,
                title: "Ignite Digital Revolution",
                description: "Embracing technology to deliver cutting-edge educational experiences"
              },
              {
                icon: Users,
                title: "Empower Universities",
                description: "Strengthening academic partnerships to enhance global educational standards"
              }
            ].map((goal, index) => {
              const IconComponent = goal.icon;
              return (
                <div key={index} className="text-center group">
                  <div className="w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform">
                    <IconComponent className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-semibold mb-4">{goal.title}</h3>
                  <p className="text-gray-300">{goal.description}</p>
                </div>
              );
            })}
          </div>
        </div>
      </section>

      {/* University Partnerships */}
      <section className="py-20 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-[#1A1A40] mb-4">Prestigious University Partnerships</h2>
            <p className="text-xl text-gray-600">
              Collaborating with world-renowned institutions to deliver excellence in education
            </p>
          </div>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {[
              "Missouri State University",
              "University of Abertay", 
              "University of Dundee",
              "Edinburgh Napier University"
            ].map((university, index) => (
              <div key={index} className="bg-white rounded-lg p-6 shadow-md hover:shadow-lg transition-shadow text-center">
                <div className="w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center mx-auto mb-4">
                  <GraduationCap className="h-8 w-8 text-white" />
                </div>
                <h3 className="font-semibold text-[#1A1A40]">{university}</h3>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Certificate Showcase Section */}
      <section className="py-20 bg-gradient-to-br from-[#1A1A40] to-[#1A1A40]/90">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            {/* Left Content */}
            <div className="text-white">
              <h2 className="text-4xl font-bold mb-6">
                Internationally Recognized 
                <span className="text-[#ED1C24]"> Credentials</span>
              </h2>
              <p className="text-xl text-white/90 mb-8">
                Earn prestigious IBDL certifications that are valued by employers worldwide. 
                Our credentials demonstrate your expertise and commitment to professional excellence.
              </p>
              
              <div className="space-y-6 mb-8">
                <div className="flex items-start">
                  <div className="w-2 h-2 bg-[#ED1C24] rounded-full mt-3 mr-4 flex-shrink-0"></div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2">University Partnership Validated</h3>
                    <p className="text-white/80">Credentials backed by Missouri State University and other leading institutions</p>
                  </div>
                </div>
                <div className="flex items-start">
                  <div className="w-2 h-2 bg-[#ED1C24] rounded-full mt-3 mr-4 flex-shrink-0"></div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2">Blockchain Verified</h3>
                    <p className="text-white/80">Digital certificates with secure verification technology</p>
                  </div>
                </div>
                <div className="flex items-start">
                  <div className="w-2 h-2 bg-[#ED1C24] rounded-full mt-3 mr-4 flex-shrink-0"></div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2">Globally Accepted</h3>
                    <p className="text-white/80">Recognized across 39 countries by leading organizations</p>
                  </div>
                </div>
              </div>
              
              <Button 
                size="lg" 
                className="bg-[#ED1C24] hover:bg-red-700 text-white px-8 py-4"
                onClick={onShowGetStarted}
              >
                <Star className="mr-2 h-5 w-5" />
                Start Your Certification Journey
              </Button>
            </div>
            
            {/* Right - Certificate Image */}
            <div className="relative">
              <div className="relative transform rotate-2 hover:rotate-0 transition-transform duration-300">
                <img 
                  src={certificateImage} 
                  alt="IBDL Essential Certificate - Sample credential showcasing professional recognition" 
                  className="w-full h-auto rounded-lg shadow-2xl border-4 border-white/10"
                />
                <div className="absolute -top-4 -right-4 w-16 h-16 bg-[#ED1C24] rounded-full flex items-center justify-center shadow-lg">
                  <CheckCircle className="h-8 w-8 text-white" />
                </div>
              </div>
              
              {/* Floating elements */}
              <div className="absolute -top-8 -left-8 w-20 h-20 bg-gradient-to-br from-[#ED1C24]/20 to-[#ED1C24]/10 rounded-full opacity-60"></div>
              <div className="absolute -bottom-6 -right-6 w-16 h-16 bg-gradient-to-br from-white/20 to-white/10 rounded-full opacity-60"></div>
            </div>
          </div>
        </div>
      </section>

      {/* We Are Proud to Serve Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold text-[#1A1A40] mb-4">WE ARE PROUD TO SERVE</h2>
            <p className="text-xl text-gray-600">
              Trusted by leading organizations and institutions worldwide
            </p>
          </div>
          
          {/* Sliding Logos Container */}
          <div className="relative overflow-hidden">
            <div className="flex animate-slide-infinite">
              {/* First set of logos */}
              <div className="flex items-center justify-center min-w-0 shrink-0">
                <img src={partner1} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner2} alt="National Council for Women" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner3} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner4} alt="Rowad 2030" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner5} alt="Ministry of Electricity" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner6} alt="Leadership & Management Development Center" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner7} alt="EAPD - Egyptian Agency of Partnership for Development" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner8} alt="IATF - Intra-African Trade Fair" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner9} alt="Partner Organization" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner10} alt="EACA - Egyptian Anti-Corruption Academy" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner11} alt="IIP - Investment in People" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner12} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
              </div>
              
              {/* Duplicate set for seamless loop */}
              <div className="flex items-center justify-center min-w-0 shrink-0">
                <img src={partner1} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner2} alt="National Council for Women" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner3} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner4} alt="Rowad 2030" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner5} alt="Ministry of Electricity" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner6} alt="Leadership & Management Development Center" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner7} alt="EAPD - Egyptian Agency of Partnership for Development" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner8} alt="IATF - Intra-African Trade Fair" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner9} alt="Partner Organization" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner10} alt="EACA - Egyptian Anti-Corruption Academy" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner11} alt="IIP - Investment in People" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
                <img src={partner12} alt="Partner Logo" className="h-16 mx-8 object-contain opacity-70 hover:opacity-100 transition-opacity" />
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-[#ED1C24]">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-white mb-6">
            Ready to Transform Your Learning Journey?
          </h2>
          <p className="text-xl text-red-100 mb-8 max-w-2xl mx-auto">
            Join thousands of professionals who have accelerated their careers with IBDL's 
            comprehensive learning solutions and globally recognized qualifications.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button 
              size="lg" 
              className="bg-white text-[#ED1C24] hover:bg-gray-100 px-8 py-4 text-lg"
              onClick={handleGetStarted}
            >
              <Award className="mr-2 h-5 w-5" />
              Get Started
            </Button>
            <Button 
              size="lg" 
              className="bg-[#1A1A40] hover:bg-[#2A2A60] text-white border-[#1A1A40] px-8 py-4 text-lg"
            >
              <Mail className="mr-2 h-5 w-5" />
              Request Information
            </Button>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-[#1A1A40] text-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div>
              <img src={footerLogo} alt="IBDL Logo" className="h-12 w-auto mb-4" />
              <p className="text-gray-300 mb-4">
                We develop the learning journeys that enable every person and organization to move forward. Leading international business education since 2006.
              </p>
              <div className="flex space-x-3">
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <Linkedin className="h-4 w-4 text-white" />
                </a>
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <Twitter className="h-4 w-4 text-white" />
                </a>
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <Facebook className="h-4 w-4 text-white" />
                </a>
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <Instagram className="h-4 w-4 text-white" />
                </a>
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <Youtube className="h-4 w-4 text-white" />
                </a>
                <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                  <MessageCircle className="h-4 w-4 text-white" />
                </a>
              </div>
            </div>
            
            <div>
              <h3 className="text-lg font-semibold mb-4">Our Products</h3>
              <ul className="space-y-2 text-gray-300">
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Professional Qualifications</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Business Simulations</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Psychometric Assessments</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Executive Education</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="text-lg font-semibold mb-4">Our Services</h3>
              <ul className="space-y-2 text-gray-300">
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Customized Learning Solutions</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Accreditation Services</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Corporate Training</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">University Partnerships</a></li>
              </ul>
            </div>
            
            <div>
              <h3 className="text-lg font-semibold mb-4">Company</h3>
              <ul className="space-y-2 text-gray-300">
                <li><a href="/about" className="hover:text-[#ED1C24] transition-colors">About IBDL</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Careers</a></li>
                <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Contact Us</a></li>
                <li><a href="/news" className="hover:text-[#ED1C24] transition-colors">News & Media</a></li>
              </ul>
            </div>
          </div>
          
          <div className="border-t border-gray-600 mt-12 pt-8 text-center text-gray-300">
            <p>&copy; 2025 International Board for Development and Learning (IBDL). All rights reserved.</p>
            <div className="mt-2 space-x-4">
              <a href="#" className="hover:text-[#ED1C24] transition-colors">Privacy Policy</a>
              <span>|</span>
              <a href="#" className="hover:text-[#ED1C24] transition-colors">Terms of Service</a>
              <span>|</span>
              <a href="#" className="hover:text-[#ED1C24] transition-colors">Cookie Policy</a>
              <span>|</span>
              <a href="#" className="hover:text-[#ED1C24] transition-colors">Accessibility</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  );
}