import React from "react";
import { useQuery } from "@tanstack/react-query";
import WebsiteLayout from "@/components/WebsiteLayout";
import { Skeleton } from "@/components/ui/skeleton";
import { Badge } from "@/components/ui/badge";

export default function About() {
  // Fetch CMS content for this page
  const { data: pageData, isLoading } = useQuery({
    queryKey: ["backend/api/cms/pages/about"],
    staleTime: 5 * 60 * 1000, // 5 minutes
  });

  if (isLoading) {
    return (
      <WebsiteLayout>
        <div className="min-h-screen bg-gray-50">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div className="space-y-6">
              <Skeleton className="h-12 w-3/4 mx-auto" />
              <Skeleton className="h-6 w-1/2 mx-auto" />
              <div className="space-y-4 mt-12">
                <Skeleton className="h-4 w-full" />
                <Skeleton className="h-4 w-5/6" />
                <Skeleton className="h-4 w-4/5" />
              </div>
            </div>
          </div>
        </div>
      </WebsiteLayout>
    );
  }

  return (
    <WebsiteLayout>
      <div className="min-h-screen bg-gray-50">
        {/* Hero Section */}
        <div className="bg-gradient-to-r from-[#1A1A40] to-[#2A2A50] text-white">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div className="text-center">
              <Badge variant="secondary" className="mb-4 bg-[#ffffff] text-[#1c1c42]">
                About IBDL
              </Badge>
              <h1 className="text-4xl md:text-5xl font-bold mb-6">
                {(pageData as any)?.title || "About IBDL Learning Group"}
              </h1>
              <p className="text-xl text-gray-300 max-w-3xl mx-auto">
                {(pageData as any)?.content || "Leading international business development and learning solutions since 2006"}
              </p>
              <div className="mt-8 text-sm text-gray-400">
                {(pageData as any)?.updatedAt && (
                  <span>Last updated: {new Date((pageData as any).updatedAt).toLocaleDateString()}</span>
                )}
              </div>
            </div>
          </div>
        </div>

        {/* Content Section */}
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
          <div className="prose prose-lg max-w-4xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">Our Story</h2>
              <p className="text-lg text-gray-600">
                We develop learning journeys that enable every person and organization to move forward.
              </p>
            </div>

            {/* CMS Integration Notice */}
            <div className="bg-blue-50 border border-blue-200 rounded-lg p-6 text-center">
              <h3 className="text-lg font-semibold text-blue-900 mb-2">Content Management</h3>
              <p className="text-blue-700">
                This page content is managed through the CMS and can be updated by administrators.
                {pageData && typeof pageData === 'object' && pageData && 'id' in pageData && (
                  <span className="block mt-2 text-sm">
                    Page ID: {String((pageData as any).id)} | Status: {String((pageData as any).status)}
                  </span>
                )}
              </p>
            </div>
          </div>
        </div>
      </div>
    </WebsiteLayout>
  );
}