import { Card, CardContent } from "@/components/ui/card";
import { LucideIcon } from "lucide-react";

interface FeatureCardProps {
  icon: LucideIcon;
  title: string;
  description: string;
  iconColor?: string;
  className?: string;
  onClick?: () => void;
}

export function FeatureCard({ 
  icon: Icon, 
  title, 
  description, 
  iconColor = 'bg-blue-100 text-blue-600',
  className = '',
  onClick
}: FeatureCardProps) {
  return (
    <Card 
      className={`feature-card cursor-pointer ${className}`}
      onClick={onClick}
    >
      <CardContent className="p-6">
        <div className={`w-12 h-12 ${iconColor} rounded-lg flex items-center justify-center mb-4`}>
          <Icon className="w-6 h-6" />
        </div>
        <h3 className="text-lg font-semibold text-foreground mb-2">{title}</h3>
        <p className="text-muted-foreground text-sm">{description}</p>
      </CardContent>
    </Card>
  );
}
