import React, { useState } from "react";
import { Button } from "@/components/ui/button";
import { 
  ShoppingBag, Mail, Briefcase, Languages, ChevronDown, Menu, X, 
  Linkedin, Twitter, Facebook, Instagram, Youtube, MessageCircle, Home
} from "lucide-react";
import ibdlLogo from "@assets/logo_1751230646761.png";
import footerLogo from "@assets/footer-logo_1751304691992.png";
import { Link } from "wouter";

interface SharedLayoutProps {
  children: React.ReactNode;
}

export default function SharedLayout({ children }: SharedLayoutProps) {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [expandedMobileSection, setExpandedMobileSection] = useState<string | null>(null);

  const handleMobileMenuToggle = () => {
    setMobileMenuOpen(!mobileMenuOpen);
    if (!mobileMenuOpen) {
      setExpandedMobileSection(null);
    }
  };

  const toggleMobileSection = (section: string) => {
    setExpandedMobileSection(expandedMobileSection === section ? null : section);
  };

  return (
    <div className="min-h-screen bg-white">
      {/* Fixed Top Bar */}
      <div className="bg-gray-100 border-b border-gray-200 relative z-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex items-center justify-between h-10 text-sm">
            <div className="flex items-center space-x-4">
              <span className="text-gray-600">Welcome to IBDL Learning Group</span>
            </div>
            <div className="flex items-center space-x-4">
              <Link href="/store">
                <Button variant="ghost" size="sm" className="text-gray-600 hover:text-[#1A1A40] h-8 px-2">
                  <ShoppingBag className="h-3 w-3 mr-1" />
                  Store
                </Button>
              </Link>
              <Link href="/contact">
                <Button variant="ghost" size="sm" className="text-gray-600 hover:text-[#1A1A40] h-8 px-2">
                  <Mail className="h-3 w-3 mr-1" />
                  Contact us
                </Button>
              </Link>
              <Button variant="ghost" size="sm" className="text-gray-600 hover:text-[#1A1A40] h-8 px-2">
                <Briefcase className="h-3 w-3 mr-1" />
                Careers
              </Button>
              <Button variant="ghost" size="sm" className="text-gray-600 hover:text-[#1A1A40] h-8 px-2">
                <Languages className="h-3 w-3 mr-1" />
                Language
                <ChevronDown className="h-3 w-3 ml-1" />
              </Button>
            </div>
          </div>
        </div>
      </div>

      {/* Fixed Main Navigation Header */}
      <header className="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-40">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex items-center justify-between h-16">
            {/* Logo */}
            <Link href="/">
              <div className="flex-shrink-0 cursor-pointer">
                <img
                  src={ibdlLogo}
                  alt="IBDL Logo"
                  className="h-12 w-auto"
                />
              </div>
            </Link>

            {/* Desktop Navigation */}
            <nav className="hidden lg:flex items-center space-x-8">
              <Link href="/">
                <Button variant="ghost" className="text-[#1A1A40] hover:text-[#ED1C24] font-medium">
                  <Home className="h-4 w-4 mr-2" />
                  home
                </Button>
              </Link>

              {/* Who we are Mega Menu */}
              <div className="relative group">
                <Button variant="ghost" className="text-[#1A1A40] hover:text-[#ED1C24] font-medium">
                  Who we are
                  <ChevronDown className="ml-1 h-4 w-4" />
                </Button>
                <div className="absolute left-1/2 transform -translate-x-1/2 top-full mt-2 w-80 bg-white rounded-lg shadow-xl border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                  <div className="p-6">
                    <div className="space-y-3">
                      <Link href="/about">
                        <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                          About IBDL
                        </button>
                      </Link>
                      <Link href="/strategy">
                        <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                          Strategy
                        </button>
                      </Link>
                      <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                        CEO Statement
                      </button>
                      <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                        Board of Trustees
                      </button>
                      <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                        Body of knowledge
                      </button>
                      <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                        Proud to Serve
                      </button>
                    </div>
                  </div>
                </div>
              </div>

              {/* Our Products Mega Menu */}
              <div className="relative group">
                <Button variant="ghost" className="text-[#1A1A40] hover:text-[#ED1C24] font-medium">
                  Our Products
                  <ChevronDown className="ml-1 h-4 w-4" />
                </Button>
                <div className="absolute left-1/2 transform -translate-x-1/2 top-full mt-2 w-96 bg-white rounded-lg shadow-xl border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                  <div className="p-6">
                    <div className="grid grid-cols-2 gap-6">
                      <div>
                        <h3 className="font-semibold text-[#1A1A40] mb-3">Qualifications</h3>
                        <div className="space-y-2">
                          <Link href="/qualifications">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              IBDL Essential
                            </button>
                          </Link>
                          <Link href="/qualifications">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              IBDL Professional
                            </button>
                          </Link>
                          <Link href="/qualifications">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              IBDL Master
                            </button>
                          </Link>
                          <Link href="/qualifications">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              Certified Educator
                            </button>
                          </Link>
                        </div>
                      </div>
                      <div>
                        <h3 className="font-semibold text-[#1A1A40] mb-3">Business Simulation</h3>
                        <div className="space-y-2">
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Win vs. War
                          </button>
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Master Board Game
                          </button>
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Sparta
                          </button>
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Maven
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              {/* Our Services Mega Menu */}
              <div className="relative group">
                <Button variant="ghost" className="text-[#1A1A40] hover:text-[#ED1C24] font-medium">
                  Our Services
                  <ChevronDown className="ml-1 h-4 w-4" />
                </Button>
                <div className="absolute left-1/2 transform -translate-x-1/2 top-full mt-2 w-96 bg-white rounded-lg shadow-xl border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                  <div className="p-6">
                    <div className="grid grid-cols-2 gap-6">
                      <div>
                        <h3 className="font-semibold text-[#1A1A40] mb-3">Customized Learning Solutions</h3>
                        <div className="space-y-2">
                          <Link href="/solutions">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              Solutions for Learning and Development
                            </button>
                          </Link>
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Solutions for Entrepreneurship
                          </button>
                          <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                            Solutions for Higher Education
                          </button>
                        </div>
                      </div>
                      <div>
                        <h3 className="font-semibold text-[#1A1A40] mb-3">Accreditation Services</h3>
                        <div className="space-y-2">
                          <Link href="/accreditation">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              Training provider accreditation
                            </button>
                          </Link>
                          <Link href="/accreditation">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              Testing provider accreditation
                            </button>
                          </Link>
                          <Link href="/accreditation">
                            <button className="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                              Corporate accreditation
                            </button>
                          </Link>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              {/* Media Mega Menu */}
              <div className="relative group">
                <Button variant="ghost" className="text-[#1A1A40] hover:text-[#ED1C24] font-medium">
                  Media
                  <ChevronDown className="ml-1 h-4 w-4" />
                </Button>
                <div className="absolute left-1/2 transform -translate-x-1/2 top-full mt-2 w-80 bg-white rounded-lg shadow-xl border border-gray-200 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                  <div className="p-6">
                    <div className="space-y-3">
                      <Link href="/news">
                        <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                          News & Events
                        </button>
                      </Link>
                      <Link href="/magazine">
                        <button className="block w-full text-left px-3 py-2 text-gray-700 hover:text-[#ED1C24] hover:bg-gray-50 rounded-md transition-colors">
                          The Learning Edit Magazine
                        </button>
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </nav>

            {/* Desktop Action Buttons */}
            <div className="hidden lg:flex items-center space-x-4">
              <Link href="/sign-in">
                <Button variant="outline" className="border-[#1A1A40] text-[#1A1A40] hover:bg-[#1A1A40] hover:text-white">
                  Sign In
                </Button>
              </Link>
              <Button 
                className="bg-[#ED1C24] hover:bg-red-700 text-white"
                onClick={() => window.location.href = '/get-started'}
              >
                Get Started
              </Button>
            </div>

            {/* Mobile menu button */}
            <div className="lg:hidden">
              <Button
                variant="ghost"
                size="sm"
                onClick={handleMobileMenuToggle}
                className="text-[#1A1A40]"
              >
                {mobileMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
              </Button>
            </div>
          </div>
        </div>

        {/* Mobile Navigation Menu */}
        {mobileMenuOpen && (
          <div className="lg:hidden bg-white border-t border-gray-200 shadow-lg">
            <div className="px-4 py-6 space-y-4">
              <Link href="/">
                <Button variant="ghost" className="w-full justify-start text-[#1A1A40] hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                  <Home className="h-4 w-4 mr-2" />
                  home
                </Button>
              </Link>
              
              {/* Mobile Who we are section */}
              <div>
                <Button 
                  variant="ghost" 
                  className="w-full justify-between text-[#1A1A40] hover:text-[#ED1C24]"
                  onClick={() => toggleMobileSection('who-we-are')}
                >
                  Who we are
                  <ChevronDown className={`h-4 w-4 transition-transform ${expandedMobileSection === 'who-we-are' ? 'rotate-180' : ''}`} />
                </Button>
                {expandedMobileSection === 'who-we-are' && (
                  <div className="pl-4 mt-2 space-y-2">
                    <Link href="/about">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        About IBDL
                      </Button>
                    </Link>
                    <Link href="/strategy">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        Strategy
                      </Button>
                    </Link>
                  </div>
                )}
              </div>

              {/* Mobile Our Products section */}
              <div>
                <Button 
                  variant="ghost" 
                  className="w-full justify-between text-[#1A1A40] hover:text-[#ED1C24]"
                  onClick={() => toggleMobileSection('our-products')}
                >
                  Our Products
                  <ChevronDown className={`h-4 w-4 transition-transform ${expandedMobileSection === 'our-products' ? 'rotate-180' : ''}`} />
                </Button>
                {expandedMobileSection === 'our-products' && (
                  <div className="pl-4 mt-2 space-y-2">
                    <Link href="/qualifications">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        Qualifications
                      </Button>
                    </Link>
                  </div>
                )}
              </div>

              {/* Mobile Our Services section */}
              <div>
                <Button 
                  variant="ghost" 
                  className="w-full justify-between text-[#1A1A40] hover:text-[#ED1C24]"
                  onClick={() => toggleMobileSection('our-services')}
                >
                  Our Services
                  <ChevronDown className={`h-4 w-4 transition-transform ${expandedMobileSection === 'our-services' ? 'rotate-180' : ''}`} />
                </Button>
                {expandedMobileSection === 'our-services' && (
                  <div className="pl-4 mt-2 space-y-2">
                    <Link href="/solutions">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        Learning Solutions
                      </Button>
                    </Link>
                    <Link href="/accreditation">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        Accreditation Services
                      </Button>
                    </Link>
                  </div>
                )}
              </div>

              {/* Mobile Media section */}
              <div>
                <Button 
                  variant="ghost" 
                  className="w-full justify-between text-[#1A1A40] hover:text-[#ED1C24]"
                  onClick={() => toggleMobileSection('media')}
                >
                  Media
                  <ChevronDown className={`h-4 w-4 transition-transform ${expandedMobileSection === 'media' ? 'rotate-180' : ''}`} />
                </Button>
                {expandedMobileSection === 'media' && (
                  <div className="pl-4 mt-2 space-y-2">
                    <Link href="/news">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        News & Events
                      </Button>
                    </Link>
                    <Link href="/magazine">
                      <Button variant="ghost" size="sm" className="w-full justify-start text-gray-600 hover:text-[#ED1C24]" onClick={() => setMobileMenuOpen(false)}>
                        The Learning Edit Magazine
                      </Button>
                    </Link>
                  </div>
                )}
              </div>

              <div className="pt-4 border-t border-gray-200 space-y-2">
                <Link href="/sign-in">
                  <Button variant="outline" className="w-full border-[#1A1A40] text-[#1A1A40] hover:bg-[#1A1A40] hover:text-white" onClick={() => setMobileMenuOpen(false)}>
                    Sign In
                  </Button>
                </Link>
                <Button 
                  className="w-full bg-[#ED1C24] hover:bg-red-700 text-white"
                  onClick={() => {
                    setMobileMenuOpen(false);
                    window.location.href = '/get-started';
                  }}
                >
                  Get Started
                </Button>
              </div>
            </div>
          </div>
        )}
      </header>

      {/* Main Content */}
      <main>
        {children}
      </main>

      {/* Fixed Footer */}
      <footer className="bg-[#1A1A40] text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {/* Logo and Description */}
            <div className="space-y-4">
              <img
                src={footerLogo}
                alt="IBDL Footer Logo"
                className="h-16 w-auto"
              />
              <p className="text-gray-300 text-sm leading-relaxed">
                We develop the learning journeys that enables every person and organization to move forward
              </p>
              <div className="flex space-x-3">
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <Linkedin className="h-4 w-4 text-white" />
                </button>
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <Twitter className="h-4 w-4 text-white" />
                </button>
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <Facebook className="h-4 w-4 text-white" />
                </button>
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <Instagram className="h-4 w-4 text-white" />
                </button>
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <Youtube className="h-4 w-4 text-white" />
                </button>
                <button className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors">
                  <MessageCircle className="h-4 w-4 text-white" />
                </button>
              </div>
            </div>

            {/* Who We Are */}
            <div>
              <h3 className="text-lg font-semibold mb-4">Who We Are</h3>
              <ul className="space-y-2 text-sm text-gray-300">
                <li><Link href="/about" className="hover:text-[#ED1C24] transition-colors">About IBDL</Link></li>
                <li><Link href="/strategy" className="hover:text-[#ED1C24] transition-colors">Strategy</Link></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">CEO Statement</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Board of Trustees</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Body of Knowledge</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Proud to Serve</button></li>
              </ul>
            </div>

            {/* Our Products */}
            <div>
              <h3 className="text-lg font-semibold mb-4">Our Products</h3>
              <ul className="space-y-2 text-sm text-gray-300">
                <li><Link href="/qualifications" className="hover:text-[#ED1C24] transition-colors">IBDL Essential</Link></li>
                <li><Link href="/qualifications" className="hover:text-[#ED1C24] transition-colors">IBDL Professional</Link></li>
                <li><Link href="/qualifications" className="hover:text-[#ED1C24] transition-colors">IBDL Master</Link></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Business Simulations</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Assessment Services</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Executive Education</button></li>
              </ul>
            </div>

            {/* Our Services */}
            <div>
              <h3 className="text-lg font-semibold mb-4">Our Services</h3>
              <ul className="space-y-2 text-sm text-gray-300">
                <li><Link href="/solutions" className="hover:text-[#ED1C24] transition-colors">Learning Solutions</Link></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Entrepreneurship Solutions</button></li>
                <li><button className="hover:text-[#ED1C24] transition-colors text-left">Higher Education Solutions</button></li>
                <li><Link href="/accreditation" className="hover:text-[#ED1C24] transition-colors">Accreditation Services</Link></li>
                <li><Link href="/news" className="hover:text-[#ED1C24] transition-colors">News & Events</Link></li>
                <li><Link href="/magazine" className="hover:text-[#ED1C24] transition-colors">The Learning Edit</Link></li>
              </ul>
            </div>
          </div>

          <div className="border-t border-gray-700 mt-8 pt-8 text-center">
            <div className="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
              <p className="text-sm text-gray-400">
                @2024 IBDL LEARNING GROUP
              </p>
              <div className="flex space-x-6 text-sm text-gray-400">
                <button className="hover:text-[#ED1C24] transition-colors">Privacy policy</button>
                <button className="hover:text-[#ED1C24] transition-colors">Website terms and conditions</button>
              </div>
            </div>
          </div>
        </div>
      </footer>
    </div>
  );
}