import React from "react";
import { Linkedin, Twitter, Facebook, Instagram, Youtube, MessageCircle } from "lucide-react";
import footerLogo from "@assets/footer-logo_1751304691992.png";

export default function Footer() {
  return (
    <footer className="bg-[#1A1A40] text-white py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          <div>
            <img src={footerLogo} alt="IBDL Logo" className="h-12 w-auto mb-4" />
            <p className="text-gray-300 mb-4">
              We develop the learning journeys that enable every person and organization to move forward. Leading international business education since 2006.
            </p>
            <div className="flex space-x-3">
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <Linkedin className="h-4 w-4 text-white" />
              </a>
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <Twitter className="h-4 w-4 text-white" />
              </a>
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <Facebook className="h-4 w-4 text-white" />
              </a>
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <Instagram className="h-4 w-4 text-white" />
              </a>
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <Youtube className="h-4 w-4 text-white" />
              </a>
              <a href="#" className="w-8 h-8 bg-[#ED1C24] rounded-full flex items-center justify-center hover:bg-red-700 transition-colors shrink-0">
                <MessageCircle className="h-4 w-4 text-white" />
              </a>
            </div>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Our Products</h3>
            <ul className="space-y-2 text-gray-300">
              <li><a href="/qualifications" className="hover:text-[#ED1C24] transition-colors">Professional Qualifications</a></li>
              <li><a href="/store" className="hover:text-[#ED1C24] transition-colors">Business Simulations</a></li>
              <li><a href="/store" className="hover:text-[#ED1C24] transition-colors">Psychometric Assessments</a></li>
              <li><a href="/store" className="hover:text-[#ED1C24] transition-colors">Executive Education</a></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Our Services</h3>
            <ul className="space-y-2 text-gray-300">
              <li><a href="/solutions" className="hover:text-[#ED1C24] transition-colors">Customized Learning Solutions</a></li>
              <li><a href="/credentials" className="hover:text-[#ED1C24] transition-colors">Accreditation Services</a></li>
              <li><a href="/solutions" className="hover:text-[#ED1C24] transition-colors">Corporate Training</a></li>
              <li><a href="/solutions" className="hover:text-[#ED1C24] transition-colors">University Partnerships</a></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Company</h3>
            <ul className="space-y-2 text-gray-300">
              <li><a href="/about" className="hover:text-[#ED1C24] transition-colors">About IBDL</a></li>
              <li><a href="#" className="hover:text-[#ED1C24] transition-colors">Careers</a></li>
              <li><a href="/contact" className="hover:text-[#ED1C24] transition-colors">Contact Us</a></li>
              <li><a href="/news" className="hover:text-[#ED1C24] transition-colors">News & Media</a></li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-gray-600 mt-12 pt-8 text-center text-gray-300">
          <p>&copy; 2025 International Board for Development and Learning (IBDL). All rights reserved.</p>
          <div className="mt-2 space-x-4">
            <a href="#" className="hover:text-[#ED1C24] transition-colors">Privacy Policy</a>
            <span>|</span>
            <a href="#" className="hover:text-[#ED1C24] transition-colors">Terms of Service</a>
            <span>|</span>
            <a href="#" className="hover:text-[#ED1C24] transition-colors">Cookie Policy</a>
            <span>|</span>
            <a href="#" className="hover:text-[#ED1C24] transition-colors">Accessibility</a>
          </div>
        </div>
      </div>
    </footer>
  );
}